import { NextRequest, NextResponse } from "next/server";
import { createAnnonce, getAllAnnonces } from "@/lib/services/annonceService";

export async function POST(req: NextRequest) {
  try {
    const formData = await req.formData();

    const agentId = formData.get("agentId") as string | null;
    const title = formData.get("title") as string | null;
    const address = formData.get("address") as string | null;
    const pays = formData.get("pays") as string | null;
    const ville = formData.get("ville") as string | null;
    const codePostal = formData.get("codePostal") as string | null;
    const description = formData.get("description") as string | null;
    const prix = formData.get("prix") as string | null;

    const files = formData.getAll("images") as File[];
    const file = files[0] ?? null;

    if (!agentId || !title || !prix || !file) {
      return NextResponse.json(
        { message: "Les champs requis sont manquants." },
        { status: 400 }
      );
    }

    const ALLOWED = new Set(["image/jpeg", "image/png", "image/webp"]);
    if (!ALLOWED.has(file.type)) {
      return NextResponse.json(
        { message: "Type d’image non autorisé." },
        { status: 415 }
      );
    }

    const buffer = Buffer.from(await file.arrayBuffer());

    const newAnnonce = await createAnnonce({
      agentId: Number(agentId),
      title,
      address: address ?? "",
      pays: pays ?? "",
      ville: ville ?? "",
      codePostal: codePostal ?? "",
      description: description ?? "",
      prix: Number(prix),
      imagePrincipale: buffer,
    });

    return NextResponse.json(newAnnonce, { status: 201 });
  } catch (error) {
    console.error("Erreur API lors de la création de l'annonce:", error);
    return NextResponse.json(
      { message: "Erreur interne du serveur." },
      { status: 500 }
    );
  }
}
