import { Annonce } from "@prisma/client";
import prisma from "@/lib/global/globalPrisma";
import { AnnonceWithGallery } from "../types/AnnonceProps";

export const createAnnonce = async (data: {
    agentId: number;
    title: string;
    address: string;
    city: string;
    postalCode: string;
    country: string;
    description: string;
    price: number;
    mainImg?: string;
}): Promise<Annonce> => {
    const annonce = await prisma.annonce.create({
        data: {
            agentId: data.agentId,
            title: data.title,
            address: data.address,
            city: data.city,
            postalCode: data.postalCode,
            country: data.country,
            description: data.description,
            price: data.price,
            mainImg: data.mainImg ?? null,
        },
    });
    return annonce;
};

export const getAnnonceById = async (id: number): Promise<Annonce | null> => {
    return await prisma.annonce.findUnique({
        where: { id },
    });
};

export const getAnnonceByIdInclude = async (id: number): Promise<AnnonceWithGallery | null> => {
    return prisma.annonce.findUnique({
        where: { id },
        include: {
            gallery: { },
        },
    });
};

export const updateAnnonce = async (
    id: number,
    data: {
        title?: string;
        address?: string;
        ville?: string;
        codePostal?: string;
        pays?: string;
        description?: string;
        prix?: number;
    }
): Promise<Annonce> => {
    return await prisma.annonce.update({
        where: { id },
        data: {
            title: data.title,
            address: data.address,
            city: data.ville,
            postalCode: data.codePostal,
            country: data.pays,
            description: data.description,
            price: data.prix,
        },
    });
};

export const deleteAnnonce = async (id: number): Promise<Annonce> => {
    return await prisma.annonce.delete({
        where: { id },
    });
};

export const getAllAnnonces = async (): Promise<Annonce[]> => {
    return await prisma.annonce.findMany();
};

type EditableAnnonceFields = Pick<
    Annonce,
    "title" | "address" | "city" | "postalCode" | "country" | "description" | "price" | "statut" | "mainImg"
>;

export const editAnnonce = (id: number, data: Partial<EditableAnnonceFields>): Promise<Annonce> => {
    return prisma.annonce.update({
        where: { id },
        data,
    });
};

export const editAnnonceImage = (id: number, base64Image: string): Promise<Annonce> => {
    return prisma.annonce.update({
        where: { id },
        data: { mainImg: base64Image },
    });
};
