import React from "react";
import Link from "next/link";
import { AnnonceProps } from "@/lib/types/AnnonceProps";

export const CardAnnonce: React.FC<AnnonceProps> = ({ id, titre, ville, pays, prix, imagePrincipale }) => {
    const formattedPrice = new Intl.NumberFormat("fr-FR", {
        style: "currency",
        currency: "EUR",
        minimumFractionDigits: 0,
    }).format(prix);

    const imageSrc = imagePrincipale ? `data:image/jpeg;base64,${imagePrincipale}` : "/default-image-annonce.jpg";

    return (
        <Link href={`/annonces/${id}`} className="group block">
            <div className="overflow-hidden rounded-xl border border-gray-200 bg-white transition-all duration-300 ease-in-out group-hover:-translate-y-1 group-hover:shadow-lg">
                <div className="h-48 w-full bg-gray-100">
                    <img src={imageSrc} alt={titre} className="h-full w-full object-cover" />
                </div>

                <div className="p-5">
                    <h3 className="truncate text-lg font-semibold text-gray-900">{titre}</h3>
                    <p className="mt-1 text-sm text-gray-500">
                        {ville}, {pays}
                    </p>
                    <p className="mt-4 text-xl font-bold text-gray-800">{formattedPrice}</p>
                </div>
            </div>
        </Link>
    );
};
