import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/colories.dart';
import 'package:nfc_google_sheet/database/databaseHelper.dart';
import 'package:nfc_google_sheet/model/student.dart';

class StudentForm extends StatefulWidget {
  final String cardId;

  const StudentForm({Key? key, required this.cardId}) : super(key: key);

  @override
  _StudentFormState createState() => _StudentFormState();
}

class _StudentFormState extends State<StudentForm> {
  final _formKey = GlobalKey<FormState>();
  final _studentIdController = TextEditingController();
  final _firstNameController = TextEditingController();
  final _nameController = TextEditingController();
  final _promotionController = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return AlertDialog(
      backgroundColor: Colories.background,
      title: Text(
        'Nouvel étudiant',
        style: TextStyle(color: Colories.selected),
      ),
      content: Form(
        key: _formKey,
        child: SingleChildScrollView(
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: <Widget>[
              TextFormField(
                controller: _studentIdController,
                style: TextStyle(color: Colories.unselected),
                decoration: InputDecoration(
                  labelText: 'ID Etudiant',
                  labelStyle: TextStyle(color: Colories.unselected),
                  enabledBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colories.unselected),
                  ),
                ),
                validator: (value) {
                  if (value == null || value.isEmpty) {
                    return 'Veuillez entrer l\'ID de l\'étudiant';
                  }
                  return null;
                },
              ),
              TextFormField(
                controller: _firstNameController,
                style: TextStyle(color: Colories.unselected),
                decoration: InputDecoration(
                  labelText: 'Prénom',
                  labelStyle: TextStyle(color: Colories.unselected),
                  enabledBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colories.unselected),
                  ),
                ),
                validator: (value) {
                  if (value == null || value.isEmpty) {
                    return 'Veuillez entrer le prénom';
                  }
                  return null;
                },
              ),
              TextFormField(
                controller: _nameController,
                style: TextStyle(color: Colories.unselected),
                decoration: InputDecoration(
                  labelText: 'Nom',
                  labelStyle: TextStyle(color: Colories.unselected),
                  enabledBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colories.unselected),
                  ),
                ),
                validator: (value) {
                  if (value == null || value.isEmpty) {
                    return 'Veuillez entrer le nom';
                  }
                  return null;
                },
              ),
              TextFormField(
                controller: _promotionController,
                style: TextStyle(color: Colories.unselected),
                decoration: InputDecoration(
                  labelText: 'Promotion',
                  labelStyle: TextStyle(color: Colories.unselected),
                  enabledBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colories.unselected),
                  ),
                ),
                validator: (value) {
                  if (value == null || value.isEmpty) {
                    return 'Veuillez entrer la promotion';
                  }
                  return null;
                },
              ),
            ],
          ),
        ),
      ),
      actions: <Widget>[
        TextButton(
          child: Text('Annuler', style: TextStyle(color: Colories.unselected)),
          onPressed: () {
            Navigator.of(context).pop();
          },
        ),
        ElevatedButton(
          style: ElevatedButton.styleFrom(
            backgroundColor: Colories.selected,
          ),
          child: Text('Enregistrer', style: TextStyle(color: Colories.background)),
          onPressed: () async {
            if (_formKey.currentState!.validate()) {
              final student = Student(
                cardId: widget.cardId,
                studentId: _studentIdController.text,
                firstName: _firstNameController.text,
                name: _nameController.text,
                promotion: _promotionController.text,
              );
              await DatabaseHelper.instance.insertUser(student);
              Navigator.of(context).pop();
              ScaffoldMessenger.of(context).showSnackBar(
                SnackBar(
                  content: Text('Etudiant enregistré avec succès!'),
                  backgroundColor: Colories.selected,
                ),
              );
            }
          },
        ),
      ],
    );
  }
}