import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/colories.dart';

class Folder extends StatelessWidget {
  final IconData icon;
  final String nom;
  final VoidCallback onTap;
  final bool isSelected;

  const Folder({super.key, required this.icon, required this.nom, required this.onTap, this.isSelected = false});

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: onTap,
      borderRadius: BorderRadius.circular(12),
      child: Container(
        decoration: BoxDecoration(
          color: Colories.subtitle.withValues(alpha: 0.5),
          borderRadius: BorderRadius.circular(12),
          border: isSelected
              ? Border.all(color: Colories.selected, width: 3)
              : null,
        ),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Icon(
              icon,
              size: 50,
              color: Colories.selected,
            ),
            SizedBox(height: 15),
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 8.0),
              child: Text(
                nom,
                textAlign: TextAlign.center,
                style: TextStyle(
                  color: Colories.unselected,
                  fontWeight: FontWeight.bold,
                  fontSize: 16,
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}