import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/components/folder.dart';
import 'package:nfc_google_sheet/context/app_colors.dart';
import 'package:nfc_google_sheet/pages/sheet_page.dart';
import 'package:nfc_google_sheet/utils/icon_utils.dart';

class SubjectPage extends StatefulWidget {
  final Map<String, dynamic> program;

  const SubjectPage({Key? key, required this.program}) : super(key: key);

  @override
  _SubjectPageState createState() => _SubjectPageState();
}

class _SubjectPageState extends State<SubjectPage> {
  int? _selectedSubjectIndex;

  @override
  Widget build(BuildContext context) {
    final List<dynamic> subjects = widget.program['matieres'];

    return Scaffold(
      backgroundColor: AppColors.background,
      appBar: AppBar(
        title: Text(widget.program['nom'], style: TextStyle(color: AppColors.selected)),
        backgroundColor: AppColors.background,
        elevation: 0,
        centerTitle: true,
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
              child: GridView.builder(
                gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                  crossAxisCount: 2,
                  crossAxisSpacing: 16,
                  mainAxisSpacing: 16,
                  childAspectRatio: 1,
                ),
                itemCount: subjects.length,
                itemBuilder: (context, index) {
                  final subject = subjects[index];
                  return Folder(
                    name: subject['nom'],
                    icon: getIconData(subject['icon']),
                    isSelected: _selectedSubjectIndex == index,
                    onTap: () {
                      setState(() {
                        _selectedSubjectIndex = index;
                      });
                      SheetPage.selectedSubject = subject['nom'];
                    },
                  );
                },
              ),
            ),
          ],
        ),
      ),
    );
  }
}
