import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/app_colors.dart';
import 'package:nfc_google_sheet/pages/program_page.dart';
import 'package:nfc_google_sheet/components/wide_button.dart';
import '../database/databaseHelper.dart';

class ExamPage extends StatefulWidget {
  const ExamPage({super.key});
  @override
  State<ExamPage> createState() => _ExamPageState();
}

class _ExamPageState extends State<ExamPage> {
  void _deleteAllUsers() async {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return AlertDialog(
          backgroundColor: AppColors.background,
          title: Text("Confirmer la suppression", style: TextStyle(color: AppColors.selected)),
          content: Text("Êtes-vous sûr de vouloir supprimer toutes les données des étudiants ?", style: TextStyle(color: AppColors.unselected)),
          actions: [
            TextButton(
              child: Text("Annuler", style: TextStyle(color: AppColors.unselected)),
              onPressed: () => Navigator.of(context).pop(),
            ),
            ElevatedButton(
              style: ElevatedButton.styleFrom(backgroundColor: Colors.red.shade400),
              child: Text("Supprimer", style: TextStyle(color: AppColors.background)),
              onPressed: () async {
                await DatabaseHelper.instance.clear();
                Navigator.of(context).pop();
                ScaffoldMessenger.of(context).showSnackBar(
                  SnackBar(
                    content: Text('Toutes les données ont été supprimées.'),
                    backgroundColor: Colors.red,
                  ),
                );
              },
            ),
          ],
        );
      },
    );
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.background,
      appBar: AppBar(
        title: Text('Options', style: TextStyle(color: AppColors.selected)),
        backgroundColor: AppColors.background,
        elevation: 0,
        centerTitle: true,
      ),
      body: Padding(
        padding: const EdgeInsets.all(24.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Text(
              'Gestion des données et examens',
              textAlign: TextAlign.center,
              style: TextStyle(
                fontSize: 22,
                fontWeight: FontWeight.bold,
                color: AppColors.title,
              ),
            ),
            SizedBox(height: 40),
            WideButton(
              onPressed: () {
                Navigator.push(
                  context,
                  MaterialPageRoute(builder: (context) => ProgramPage()),
                );
              },
              icon: Icons.school,
              label: "VOIR LES FILIÈRES",
              backgroundColor: AppColors.selected,
              foregroundColor: AppColors.background,
            ),
            SizedBox(height: 20),
            WideButton(
              onPressed: _deleteAllUsers,
              icon: Icons.delete_forever,
              label: "SUPPRIMER LES DONNÉES",
              backgroundColor: Colors.red.shade400,
              foregroundColor: AppColors.background,
            ),
          ],
        ),
      ),
    );
  }
}
