import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/app_colors.dart';
import 'package:nfc_google_sheet/pages/home_page.dart';
import 'package:nfc_google_sheet/pages/sheet_page.dart';
import 'package:nfc_google_sheet/pages/exam_page.dart';
import 'package:nfc_google_sheet/database/databaseHelper.dart';
import 'package:sqflite/sqflite.dart';

void main() {
  WidgetsFlutterBinding.ensureInitialized();
  runApp(MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});
  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  final instanceDbHelper = DatabaseHelper.instance;
  int _currentIndex = 1;

  @override
  void initState() {
    super.initState();
    initDatabase();
  }

  void setCurrentIndex(int index) {
    setState(() {
      _currentIndex = index;
    });
  }

  Future<Database> initDatabase() async {
    final Database dbInstance = await DatabaseHelper.instance.initDb();
    return dbInstance;
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
          body: [ExamPage(), HomePage(), SheetPage()][_currentIndex],
          bottomNavigationBar: BottomNavigationBar(
            type: BottomNavigationBarType.fixed,
            currentIndex: _currentIndex,
            selectedItemColor: AppColors.selected,
            unselectedItemColor: AppColors.unselected,
            backgroundColor: AppColors.background,
            selectedFontSize: 14,
            unselectedFontSize: 14,
            iconSize: 24,
            onTap: (index) {
              setState(() {
                _currentIndex = index;
              });
            },
            items: [
              BottomNavigationBarItem(
                  icon: Icon(Icons.file_copy, size: 24), label: "EXAMENS"),
              BottomNavigationBarItem(
                  icon: Icon(Icons.home, size: 24), label: "ACCUEIL"),
              BottomNavigationBarItem(
                  icon: Icon(Icons.remove_red_eye, size: 24), label: "DONNÉES"),
            ],
          )),
    );
  }
}
