import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/colories.dart';
import 'package:nfc_google_sheet/pages/home_page.dart';
import 'package:nfc_google_sheet/pages/sheet_page.dart';
import 'package:nfc_google_sheet/pages/exam_page.dart';
import 'package:nfc_google_sheet/database/databaseHelper.dart';
import 'package:sqflite/sqflite.dart';

void main() {
  WidgetsFlutterBinding.ensureInitialized();
  runApp(MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});
  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  final instanceBDDHelper = DatabaseHelper.instance;
  int _currentIndex = 1;

  @override
  void initState() {
    super.initState();
    initBDD();
  }

  void setCurrentIndex(int index) {
    setState(() {
      _currentIndex = index;
    });
  }

  Future<Database> initBDD() async {
    final Database dbInstance = await DatabaseHelper.instance.initDb();
    return dbInstance;
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
          body: [ExamPage(), HomePage(), SheetPage()][_currentIndex],
          bottomNavigationBar: BottomNavigationBar(
            type: BottomNavigationBarType.fixed,
            currentIndex: _currentIndex,
            selectedItemColor: Colories.selected,
            unselectedItemColor: Colories.unselected,
            backgroundColor: Colories.background,
            selectedFontSize: 14,
            unselectedFontSize: 14,
            iconSize: 24,
            onTap: (index) {
              setState(() {
                _currentIndex = index;
              });
            },
            items: [
              BottomNavigationBarItem(
                  icon: Icon(Icons.file_copy, size: 24), label: "EXAMS"),
              BottomNavigationBarItem(
                  icon: Icon(Icons.home, size: 24), label: "HOME"),
              BottomNavigationBarItem(
                  icon: Icon(Icons.remove_red_eye, size: 24), label: "SHEET"),
            ],
          )),
    );
  }
}