import 'package:flutter/material.dart';
import 'package:nfc_gogole_sheet/pages/home_page.dart';
import 'package:nfc_gogole_sheet/pages/sheet_page.dart';
import 'package:nfc_gogole_sheet/pages/stats_page.dart';
import 'package:nfc_gogole_sheet/components/build_navigation_bar.dart';

void main(){
  runApp(MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});
  @override
  State<MyApp> createState() => _MyAppState();
}
class _MyAppState extends State<MyApp>{
  int _currentIndex = 0;
  void setCurrentIndex(int index){
    setState(() {
      _currentIndex = index;
    });
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        body: [StatsPage(), HomePage(), SheetPage()][_currentIndex],
        bottomNavigationBar: BuildNavigationBar(),
      ),
    );
  }
}