import 'package:flutter/material.dart';
import 'package:nfc_gogole_sheet/context/colories.dart';

class BuildNavigationBar extends StatefulWidget {
  const BuildNavigationBar({super.key});
  @override
  State<BuildNavigationBar> createState() => _BuildNavigationBarState();
}

class _BuildNavigationBarState extends State<BuildNavigationBar> {
  int _selectedIndex = 1;
  @override
  Widget build(BuildContext context) {
    return BottomNavigationBar(
      type: BottomNavigationBarType.fixed,
      currentIndex: _selectedIndex,
      selectedItemColor: Colories.selected,
      unselectedItemColor: Colories.unselected,
      backgroundColor: Colories.background,
      selectedFontSize: 14,
      unselectedFontSize: 14,
      iconSize: 24,
      onTap: (index) {
        setState(() {
          _selectedIndex = index;
        });
      },
      items: [
        BottomNavigationBarItem(icon: Icon(Icons.query_stats_rounded, size: 24), label: "STATISTIQUES"),
        BottomNavigationBarItem(icon: Icon(Icons.home, size: 24), label: "HOME"),
        BottomNavigationBarItem(icon: Icon(Icons.remove_red_eye, size: 24), label: "SHEET"),
      ],
    );
  }
}