import 'package:flutter/material.dart';
import 'package:nfc_gogole_sheet/context/colories.dart';
import 'package:nfc_gogole_sheet/pages/home_page.dart';
import 'package:nfc_gogole_sheet/pages/sheet_page.dart';
import 'package:nfc_gogole_sheet/pages/stats_page.dart';

void main(){
  runApp(MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});
  @override
  State<MyApp> createState() => _MyAppState();
}
class _MyAppState extends State<MyApp>{
  int _currentIndex = 1;
  void setCurrentIndex(int index){
    setState(() {
      _currentIndex = index;
    });
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        body: [StatsPage(), HomePage(), SheetPage()][_currentIndex],
        bottomNavigationBar: BottomNavigationBar(
          type: BottomNavigationBarType.fixed,
          currentIndex: _currentIndex,
          selectedItemColor: Colories.selected,
          unselectedItemColor: Colories.unselected,
          backgroundColor: Colories.background,
          selectedFontSize: 14,
          unselectedFontSize: 14,
          iconSize: 24,
          onTap: (index) {
            setState(() {
              _currentIndex = index;
            });
          },
          items: [
            BottomNavigationBarItem(icon: Icon(Icons.query_stats_rounded, size: 24), label: "STATISTIQUES"),
            BottomNavigationBarItem(icon: Icon(Icons.home, size: 24), label: "HOME"),
            BottomNavigationBarItem(icon: Icon(Icons.remove_red_eye, size: 24), label: "SHEET"),
          ],
        )
      ),
    );
  }
}