import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/colories.dart';
import 'package:nfc_google_sheet/components/title.dart';
import 'package:nfc_manager/nfc_manager.dart';
import 'package:nfc_manager_ndef/nfc_manager_ndef.dart';
import 'package:nfc_manager_felica/nfc_manager_felica.dart';
import 'package:flutter_nfc_kit/flutter_nfc_kit.dart';

class HomePage extends StatelessWidget {
  const HomePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: MyHomePage(),
    );
  }
}

class MyHomePage extends StatefulWidget{
  const MyHomePage({super.key});
  @override
  State<MyHomePage> createState() => _MyHomePageState();

}

class _MyHomePageState extends State<MyHomePage>{
  String nfcData = "Tap an NFC tag";
  Future<void> startNFC() async {
    NfcAvailability isAvailable = await NfcManager.instance.checkAvailability();
    if (isAvailable != NfcAvailability.enabled) {
      setState(() {
        nfcData = "NFC is not available on this device";
      });
      return;
    }

    NfcManager.instance.startSession(
      pollingOptions: {NfcPollingOption.iso14443},
      onDiscovered: (NfcTag tag) async {
        print("data: ${tag.data.toString()}");
        await NfcManager.instance.stopSession();
      }
    );
  }

  Future<void> readNFCTag() async {
    try {
      NFCTag tag = await FlutterNfcKit.poll();
      print('NFC Tag Found: ${tag.id}');
    } catch (e) {
      print('Error reading NFC tag: $e');
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Container(
        decoration: BoxDecoration(
          image: DecorationImage(
            image: AssetImage('assets/homePageBackground.png'),
            fit: BoxFit.cover,
          ),
        ),
        child: Column(
          children: [
            SizedBox(height: 50),
            Center(
              child: TitleCustom(content: 'ENREGISTREZ - VOUS')
            ),
            SizedBox(height: 50),
            ElevatedButton(onPressed: readNFCTag, child: Text("Enregistrer sa carte")),
            Center(child: Text(nfcData)),
          ]
        ),
      ),
    );
  }
}