class Student {
  final String cardId;
  final String firstName;
  final String name;
  final String promotion;
  final String studentId;

  Student({
    required this.cardId,
    required this.firstName,
    required this.name,
    required this.promotion,
    required this.studentId
  });

  Map<String, dynamic> toMap() {
    return {
      'cardId': cardId,
      'firstName': firstName,
      'name': name,
      'promotion': promotion,
      'studentId': studentId
    };
  }

  factory Student.fromMap(Map<String, dynamic> map) {
    return Student(
        cardId: map['cardId'],
      firstName: map['firstName'],
      name: map['name'],
      promotion: map['promotion'],
      studentId: map['studentId']
    );
  }
}