import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/app_colors.dart';
import 'package:nfc_google_sheet/database/databaseHelper.dart';
import 'package:nfc_google_sheet/model/student.dart';

class StudentForm extends StatefulWidget {
  final String cardId;

  const StudentForm({Key? key, required this.cardId}) : super(key: key);

  @override
  _StudentFormState createState() => _StudentFormState();
}

class _StudentFormState extends State<StudentForm> {
  final _formKey = GlobalKey<FormState>();
  final _studentIdController = TextEditingController();
  final _firstNameController = TextEditingController();
  final _nameController = TextEditingController();
  final _promotionController = TextEditingController();

  Widget _buildTextField(TextEditingController controller, String label, String errorMessage) {
    return TextFormField(
      controller: controller,
      style: TextStyle(color: AppColors.unselected),
      decoration: InputDecoration(
        labelText: label,
        labelStyle: TextStyle(color: AppColors.unselected),
        enabledBorder: UnderlineInputBorder(
          borderSide: BorderSide(color: AppColors.unselected),
        ),
      ),
      validator: (value) {
        if (value == null || value.isEmpty) {
          return errorMessage;
        }
        return null;
      },
    );
  }

  @override
  Widget build(BuildContext context) {
    return AlertDialog(
      backgroundColor: AppColors.background,
      title: Text(
        'Nouvel étudiant',
        style: TextStyle(color: AppColors.selected),
      ),
      content: Form(
        key: _formKey,
        child: SingleChildScrollView(
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: <Widget>[
              _buildTextField(_studentIdController, 'ID Etudiant', 'Veuillez entrer l\'ID de l\'étudiant'),
              _buildTextField(_firstNameController, 'Prénom', 'Veuillez entrer le prénom'),
              _buildTextField(_nameController, 'Nom', 'Veuillez entrer le nom'),
              _buildTextField(_promotionController, 'Promotion', 'Veuillez entrer la promotion'),
            ],
          ),
        ),
      ),
      actions: <Widget>[
        TextButton(
          child: Text('Annuler', style: TextStyle(color: AppColors.unselected)),
          onPressed: () {
            Navigator.of(context).pop();
          },
        ),
        ElevatedButton(
          style: ElevatedButton.styleFrom(
            backgroundColor: AppColors.selected,
          ),
          child: Text('Enregistrer', style: TextStyle(color: AppColors.background)),
          onPressed: () async {
            if (_formKey.currentState!.validate()) {
              final student = Student(
                cardId: widget.cardId,
                studentId: _studentIdController.text,
                firstName: _firstNameController.text,
                name: _nameController.text,
                promotion: _promotionController.text,
              );
              await DatabaseHelper.instance.insertUser(student);
              Navigator.of(context).pop();
              ScaffoldMessenger.of(context).showSnackBar(
                SnackBar(
                  content: Text('Etudiant enregistré avec succès!'),
                  backgroundColor: AppColors.selected,
                ),
              );
            }
          },
        ),
      ],
    );
  }
}
