import 'dart:convert';
import 'package:flutter/services.dart';

class ProgramService {
  static final ProgramService instance = ProgramService._();
  ProgramService._();

  List<Map<String, dynamic>>? _programs;

  Future<List<Map<String, dynamic>>> getPrograms() async {
    if (_programs != null) return _programs!;
    final jsonString = await rootBundle.loadString('assets/filieres.json');
    final data = json.decode(jsonString);
    _programs = List<Map<String, dynamic>>.from(data['filieres']);
    return _programs!;
  }

  Future<List<String>> getPromotionNames() async {
    final programs = await getPrograms();
    return programs.map<String>((p) => p['nom'] as String).toList();
  }
}
