# NFC Attendance Tracker

Application mobile Flutter permettant de gérer l'émargement des étudiants via des cartes NFC, avec export des données en fichier Excel (local ou Google Drive).

## Fonctionnalités

- **Scan NFC** : lecture de cartes NFC pour enregistrer la présence des étudiants
- **Inscription automatique** : formulaire de création pour les nouveaux étudiants lors du premier scan
- **Validation** : vérification de la promotion et détection des doublons (même examen, même jour)
- **Sélection filière/matière** : navigation dans les filières et matières configurées via `filieres.json`
- **Tableau de données** : visualisation des émargements avec tri par colonne
- **Export Excel** : génération de fichiers `.xlsx` avec filtres (promotion, matière, date)
- **Export Google Drive** : upload direct en tant que Google Sheet via OAuth
- **Suppression post-export** : les données exportées sont automatiquement supprimées de la base locale

## Structure du projet

```
lib/
├── main.dart                        # Point d'entrée, navigation bottom bar
├── context/
│   └── app_colors.dart              # Palette de couleurs de l'application
├── model/
│   ├── student.dart                 # Modèle Student (cardId, studentId, firstName, name, promotion)
│   └── attendance.dart              # Modèle Attendance (promotion, subject, date, studentId)
├── database/
│   ├── database_helper.dart         # Connexion SQLite, schéma, migrations
│   ├── student_dao.dart             # DAO : insert, getByCardId
│   └── attendance_dao.dart          # DAO : insert, register, query, export Excel
├── services/
│   ├── program_service.dart         # Chargement et cache de filieres.json
│   └── google_drive_service.dart    # Authentification Google et upload Drive
├── components/
│   ├── title.dart                   # Widget titre personnalisé
│   ├── wide_button.dart             # Bouton pleine largeur avec icône
│   ├── folder.dart                  # Élément grille (filière/matière)
│   ├── selection_indicator.dart     # Affichage de la sélection courante
│   └── student_form.dart            # Formulaire d'inscription étudiant
├── pages/
│   ├── home_page.dart               # Page principale : scan NFC
│   ├── exam_page.dart               # Gestion : sélection filière, suppression données
│   ├── sheet_page.dart              # Tableau des émargements et export
│   ├── program_page.dart            # Grille de sélection des filières
│   └── subject_page.dart            # Grille de sélection des matières
└── utils/
    └── icon_utils.dart              # Mapping nom d'icône → IconData
```

## Base de données

SQLite avec deux tables (version 2) :

```sql
STUDENT
├── cardId TEXT PRIMARY KEY    -- Identifiant de la carte NFC
├── studentId TEXT             -- Numéro étudiant
├── firstName TEXT
├── name TEXT
└── promotion TEXT

ATTENDANCE
├── id INTEGER PRIMARY KEY AUTOINCREMENT
├── promotion TEXT
├── subject TEXT
├── date TEXT                  -- Format dd/MM/yyyy
└── studentId TEXT             -- FK → STUDENT(cardId)
```

## Navigation

L'application comporte 3 onglets :

| Onglet | Page | Description |
|--------|------|-------------|
| EXAMENS | `ExamPage` | Sélection filière/matière, suppression des données |
| ACCUEIL | `HomePage` | Scan NFC et enregistrement de présence |
| DONNÉES | `SheetPage` | Visualisation des émargements et export |

## Flux de scan NFC

```
1. Vérifier qu'une filière et une matière sont sélectionnées
2. Lire la carte NFC → récupérer le cardId
3. Rechercher l'étudiant en base (StudentDao)
4. Si l'étudiant existe :
   ├── Promotion différente → erreur "Mauvaise promotion"
   ├── Déjà émargé aujourd'hui pour cette matière → erreur "Déjà émargé"
   └── Sinon → enregistrer l'émargement
5. Si l'étudiant n'existe pas :
   ├── Afficher le formulaire d'inscription
   └── Après enregistrement → enregistrer l'émargement
```

## Export

Le formulaire d'export propose 3 filtres en cascade :

1. **Promotion** → charge les matières disponibles
2. **Matière** → charge les dates disponibles
3. **Date** → active les boutons d'export

Options :
- **Local** : sauvegarde via le sélecteur de fichier système
- **Drive** : upload sur Google Drive en tant que Google Sheet
- **Inclure l'ID Carte** : colonne supplémentaire optionnelle

Le fichier généré est nommé `{promotion}_{matière}_{date}.xlsx`.

## Configuration des filières

Les filières et matières sont définies dans `assets/filieres.json` :

```json
[
  {
    "nom": "M2 IWOCS",
    "icon": "school",
    "matieres": [
      { "nom": "Programmation Mobile", "icon": "phone_android" },
      { "nom": "Web Avancé", "icon": "web" }
    ]
  }
]
```

## Dépendances principales

| Package | Usage |
|---------|-------|
| `sqflite` | Base de données SQLite locale |
| `flutter_nfc_kit` | Lecture de cartes NFC |
| `excel` | Génération de fichiers Excel |
| `file_picker` | Sélection du chemin de sauvegarde |
| `google_sign_in` | Authentification Google OAuth |
| `googleapis` | API Google Drive |
| `intl` | Formatage des dates (dd/MM/yyyy) |

## Lancer le projet

```bash
flutter pub get
flutter run
```

> L'application nécessite un appareil avec NFC activé pour le scan des cartes.

__**Vidéo de présentation :**__
["Vidéo de présentation"](/public/presentation_video.mp4)
