import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/components/title.dart';
import 'package:nfc_manager/nfc_manager.dart';

class HomePage extends StatelessWidget {
  const HomePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: MyHomePage(),
    );
  }
}

class MyHomePage extends StatefulWidget{
  const MyHomePage({super.key});
  @override
  State<MyHomePage> createState() => _MyHomePageState();

}

class _MyHomePageState extends State<MyHomePage>{
  String nfcData = "Tap an NFC tag";
  Future<void> startNFC() async {
    NfcAvailability isAvailable = await NfcManager.instance.checkAvailability();
    if (isAvailable != NfcAvailability.enabled) {
      setState(() {
        nfcData = "NFC is not available on this device";
      });
      return;
    }

    NfcManager.instance.startSession(
      pollingOptions: {NfcPollingOption.iso14443},
      onDiscovered: (NfcTag tag) async {
        print("data: ${tag.data.toString()}");
        await NfcManager.instance.stopSession();
      }
    );
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Container(
        decoration: BoxDecoration(
          image: DecorationImage(
            image: AssetImage('assets/homePageBackground.png'),
            fit: BoxFit.cover,
          ),
        ),
        child: Column(
          children: [
            SizedBox(height: 50),
            Center(
              child: TitleCustom(content: 'ENREGISTREZ - VOUS')
            ),
            SizedBox(height: 50),
            ElevatedButton(onPressed: startNFC, child: Text("Enregistrer sa carte")),
            Center(child: Text(nfcData)),
          ]
        ),
      ),
    );
  }
}