class Student {
  final String studentNFCCardId;
  final String firstName;
  final String name;
  final String promotion;
  final String studentId;

  Student({
    required this.studentNFCCardId,
    required this.firstName,
    required this.name,
    required this.promotion,
    required this.studentId
  });

  Map<String, dynamic> toMap() {
    return {
      'studentNFCCardId': studentNFCCardId,
      'firstName': firstName,
      'name': name,
      'promotion': promotion,
      'studentId': studentId
    };
  }

  factory Student.fromMap(Map<String, dynamic> map) {
    return Student(
      studentNFCCardId: map['studentNFCCardId'],
      firstName: map['firstName'],
      name: map['name'],
      promotion: map['promotion'],
      studentId: map['studentId']
    );
  }
}