import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/components/folder.dart';
import 'package:nfc_google_sheet/context/colories.dart';
import 'package:nfc_google_sheet/pages/sheet_page.dart';

class MatierePage extends StatefulWidget {
  final Map<String, dynamic> filiere;

  const MatierePage({Key? key, required this.filiere}) : super(key: key);

  @override
  _MatierePageState createState() => _MatierePageState();
}

class _MatierePageState extends State<MatierePage> {
  int? _selectedMatiereIndex;

  IconData _getIconData(String iconName) {
    switch (iconName) {
      case 'psychology': return Icons.psychology;
      case 'smartphone': return Icons.smartphone;
      case 'code': return Icons.code;
      case 'computer': return Icons.computer;
      case 'sensors': return Icons.sensors;
      case 'memory': return Icons.memory;
      case 'bar_chart': return Icons.bar_chart;
      case 'smart_toy': return Icons.smart_toy;
      case 'lan': return Icons.lan;
      case 'hub': return Icons.hub;
      case 'share': return Icons.share;
      case 'functions': return Icons.functions;
      case 'security': return Icons.security;
      case 'storage': return Icons.storage;
      case 'calculate': return Icons.calculate;
      case 'code_off': return Icons.code_off;
      case 'build': return Icons.build;
      case 'chat': return Icons.chat;
      case 'mouse': return Icons.mouse;
      case 'translate': return Icons.translate;
      case 'mediation': return Icons.mediation;
      case 'science': return Icons.science;
      case 'web': return Icons.web;
      case 'dns': return Icons.dns;
      case 'wifi': return Icons.wifi;
      case 'settings_system_daydream': return Icons.settings_system_daydream;
      case 'integration_instructions': return Icons.integration_instructions;
      case 'web_asset': return Icons.web_asset;
      case 'rule': return Icons.rule;
      case 'engineering': return Icons.engineering;
      case 'architecture': return Icons.architecture;
      case 'assignment': return Icons.assignment;
      case 'work': return Icons.work;
      case 'lightbulb': return Icons.lightbulb;
      case 'directions_run': return Icons.directions_run;
      case 'analytics': return Icons.analytics;
      case 'camera': return Icons.camera;
      case 'square_foot': return Icons.square_foot;
      case 'description': return Icons.description;
      default: return Icons.subject;
    }
  }

  @override
  Widget build(BuildContext context) {
    final List<dynamic> matieres = widget.filiere['matieres'];

    return Scaffold(
      backgroundColor: Colories.background,
      appBar: AppBar(
        title: Text(widget.filiere['nom'], style: TextStyle(color: Colories.selected)),
        backgroundColor: Colories.background,
        elevation: 0,
        centerTitle: true,
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
              child: GridView.builder(
                gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                  crossAxisCount: 2,
                  crossAxisSpacing: 16,
                  mainAxisSpacing: 16,
                  childAspectRatio: 1,
                ),
                itemCount: matieres.length,
                itemBuilder: (context, index) {
                  final matiere = matieres[index];
                  return Folder(
                    nom: matiere['nom'],
                    icon: _getIconData(matiere['icon']),
                    isSelected: _selectedMatiereIndex == index,
                    onTap: () {
                      setState(() {
                        _selectedMatiereIndex = index;
                      });
                      SheetPage.selectedMatiere = matiere['nom'];
                    },
                  );
                },
              ),
            ),
          ],
        ),
      ),
    );
  }
}