import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/colories.dart';
import 'package:nfc_google_sheet/pages/filiere_page.dart';
import '../database/databaseHelper.dart';

class ExamPage extends StatelessWidget {
  const ExamPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyExamPage();
  }
}

class MyExamPage extends StatefulWidget{
  const MyExamPage({super.key});
  @override
  State<MyExamPage> createState() => _MyExamPageState();
}

class _MyExamPageState extends State<MyExamPage>{
  void _deleteAllUsers() async {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return AlertDialog(
          backgroundColor: Colories.background,
          title: Text("Confirmer la suppression", style: TextStyle(color: Colories.selected)),
          content: Text("Êtes-vous sûr de vouloir supprimer toutes les données des étudiants ?", style: TextStyle(color: Colories.unselected)),
          actions: [
            TextButton(
              child: Text("Annuler", style: TextStyle(color: Colories.unselected)),
              onPressed: () => Navigator.of(context).pop(),
            ),
            ElevatedButton(
              style: ElevatedButton.styleFrom(backgroundColor: Colors.red.shade400),
              child: Text("Supprimer", style: TextStyle(color: Colories.background)),
              onPressed: () async {
                await DatabaseHelper.instance.clear();
                Navigator.of(context).pop();
                ScaffoldMessenger.of(context).showSnackBar(
                  SnackBar(
                    content: Text('Toutes les données ont été supprimées.'),
                    backgroundColor: Colors.red,
                  ),
                );
              },
            ),
          ],
        );
      },
    );
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colories.background,
      appBar: AppBar(
        title: Text('Options', style: TextStyle(color: Colories.selected)),
        backgroundColor: Colories.background,
        elevation: 0,
        centerTitle: true,
      ),
      body: Padding(
        padding: const EdgeInsets.all(24.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Text(
              'Gestion des données et examens',
              textAlign: TextAlign.center,
              style: TextStyle(
                fontSize: 22,
                fontWeight: FontWeight.bold,
                color: Colories.title,
              ),
            ),
            SizedBox(height: 40),
            SizedBox(
              width: double.infinity,
              child: ElevatedButton.icon(
                onPressed: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => FilierePage()),
                  );
                },
                icon: Icon(Icons.school, color: Colories.background),
                label: Text(
                  "VOIR LES FILIÈRES",
                  style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
                ),
                style: ElevatedButton.styleFrom(
                  backgroundColor: Colories.selected,
                  foregroundColor: Colories.background,
                  padding: EdgeInsets.symmetric(vertical: 18),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(30),
                  ),
                ),
              ),
            ),
            SizedBox(height: 20),
            SizedBox(
              width: double.infinity,
              child: ElevatedButton.icon(
                onPressed: _deleteAllUsers,
                icon: Icon(Icons.delete_forever, color: Colories.background),
                label: Text(
                  "SUPPRIMER LES DONNÉES",
                  style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
                ),
                style: ElevatedButton.styleFrom(
                  backgroundColor: Colors.red.shade400,
                  foregroundColor: Colories.background,
                  padding: EdgeInsets.symmetric(vertical: 18),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(30),
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}