class Attendance {
  final int? id;
  final String promotion;
  final String subject;
  final String date;
  final String studentId;

  Attendance({
    this.id,
    required this.promotion,
    required this.subject,
    required this.date,
    required this.studentId,
  });

  Map<String, dynamic> toMap() {
    return {
      'promotion': promotion,
      'subject': subject,
      'date': date,
      'studentId': studentId,
    };
  }

  factory Attendance.fromMap(Map<String, dynamic> map) {
    return Attendance(
      id: map['id'],
      promotion: map['promotion'],
      subject: map['subject'],
      date: map['date'],
      studentId: map['studentId'],
    );
  }
}
