import 'package:nfc_google_sheet/database/database_helper.dart';
import 'package:nfc_google_sheet/model/student.dart';

class StudentDao {
  static final StudentDao instance = StudentDao._();
  StudentDao._();

  Future<int> insert(Student student) async {
    final db = await DatabaseHelper.instance.db;
    return await db.insert('student', student.toMap());
  }

  Future<Student?> getByCardId(String cardId) async {
    final db = await DatabaseHelper.instance.db;
    final results = await db.query('student', where: 'cardId = ?', whereArgs: [cardId]);
    if (results.isEmpty) return null;
    return Student.fromMap(results.first);
  }
}
