import 'package:flutter/material.dart';
import 'package:nfc_google_sheet/context/app_colors.dart';
import 'package:nfc_google_sheet/pages/sheet_page.dart';

class SelectionIndicator extends StatelessWidget {
  final String? prefix;

  const SelectionIndicator({super.key, this.prefix});

  @override
  Widget build(BuildContext context) {
    final hasSelection = SheetPage.selectedProgram != null && SheetPage.selectedSubject != null;
    final text = hasSelection
        ? '${prefix != null ? '$prefix ' : ''}${SheetPage.selectedProgram} — ${SheetPage.selectedSubject}'
        : 'Aucune matière sélectionnée';

    return Container(
      padding: EdgeInsets.symmetric(horizontal: 16, vertical: 10),
      decoration: BoxDecoration(
        color: AppColors.subtitle.withValues(alpha: 0.5),
        borderRadius: BorderRadius.circular(12),
      ),
      child: Text(
        text,
        textAlign: TextAlign.center,
        style: TextStyle(
          fontSize: 14,
          color: hasSelection ? AppColors.selected : AppColors.unselected.withValues(alpha: 0.6),
        ),
      ),
    );
  }
}
