export class Item {
    private barcode_id!: String;
    private product_name!: String;
    private image_url!: String;
    private image_small_url!: String;
    private brands!: String;
    private nutriscore_grade!: String;
    private product_quantity!: Number;
    private product_quantity_unit!: String;
    private ingredients_text!: String;
    private allergens_imported!: String;
    private categories!: String;
    private price!: Number;

    constructor(barcode_id: String, product_name: String, image_url: String, image_small_url: String, brands: String, nutriscore_grade: String, product_quantity: Number, product_quantity_unit: String, ingredients_text: String, allergens_imported: String, categories: String, price: Number = 0) {
        this.barcode_id = barcode_id;
        this.product_name = product_name;
        this.image_url = image_url;
        this.image_small_url = image_small_url;
        this.brands = brands;
        this.nutriscore_grade = nutriscore_grade;
        this.product_quantity = product_quantity;
        this.product_quantity_unit = product_quantity_unit;
        this.ingredients_text = ingredients_text;
        this.allergens_imported = allergens_imported;
        this.categories = categories;
        this.price = price
    }

    public getBarcodeId(): String {
        return this.barcode_id;
    }

    public getProductName(): String {
        return this.product_name;
    }

    public getImageUrl(): String {
        return this.image_url;
    }

    public getImageSmallUrl(): String {
        return this.image_small_url
    }

    public getBrands(): String {
        return this.brands
    }

    public getNutriscoreGrade(): String {
        return this.nutriscore_grade
    }

    public getProductQuantity(): Number {
        return this.product_quantity
    }

    public getProductQuantityUnit(): String {
        return this.product_quantity_unit
    }

    public getIngredeintsText(): String {
        return this.ingredients_text;
    }

    public getAllergensImported(): String {
        return this.allergens_imported;
    }

    public getCategories(): String {
        return this.categories;
    }

    public getPrice(): Number {
        return this.price;
    }
}