import { Item } from "../types/Item";
const API_BASE_URL = "http://172.26.7.129:8000"; // Julien, modifie cette variable avec ip -a

class ItemService {
    private barcodeId: String;
    private url: String;

    constructor(barcodeId: String) {
        this.barcodeId = barcodeId;
        this.url = `${API_BASE_URL}/items/barcode/${barcodeId}`;
    }

    public async getItem(): Promise<Item> {
        try {
            const response = await fetch(this.url as string);

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.detail || `Erreur serveur: ${response.statusText}`);
            }

            const itemData = await response.json();

            if (!itemData) {
                throw new Error(`Aucune donnée reçue du backend pour: ${this.barcodeId}`);
            }

            const item = new Item(
                itemData.barcode_id,
                itemData.product_name,
                itemData.image_url,
                itemData.small_image_url,
                itemData.brands,
                itemData.nutrition_grade,
                itemData.product_quantity,
                itemData.product_quantity_unit,
                itemData.ingredients,
                itemData.allergens,
                itemData.category,
                itemData.price
            );

            return item;

        } catch (error) {
            console.error("Erreur dans ItemService (appel backend):", error);
            throw error;
        }
    }
}

export default ItemService;