import { CameraType, CameraView, useCameraPermissions, BarcodeScanningResult } from 'expo-camera';
import React from 'react';
import { useState } from 'react';
import { Button, StyleSheet, Text, View } from 'react-native';

export default function ScannerScreen() {
    const [facing, setFacing] = useState<CameraType>('back');
    const [permission, requestPermission] = useCameraPermissions();
    const [scanned, setScanned] = useState(false);
    const [scannedData, setScannedData] = useState<string | null>(null);

    if (!permission) {
        return <Text> eee </Text>;
    }

    if (!permission.granted) {
        return (
            <View style={styles.container}>
                <Text>We need your permission to show the camera</Text>
                <Button onPress={requestPermission} title="grant permission" />
            </View>
        );
    }

    const handleBarcodeScanned = (scanningResult: BarcodeScanningResult) => {
        if (!scanned) {
            setScanned(true);
            setScannedData(scanningResult.data);
        }
    };
    return (
        <View style={styles.container}>
            <CameraView
                style={styles.camera}
                facing={facing}
                onBarcodeScanned={scanned ? undefined : handleBarcodeScanned}
                barcodeScannerSettings={{
                    barcodeTypes: ['ean13', 'qr'],
                }}
            />

            {scanned && (
                <View style={styles.scanResultContainer}>
                    <Text style={styles.scanResultText}>Code-barres scanné :</Text>
                    <Text style={styles.scanResultText}>{scannedData}</Text>
                    <Button title={'Scanner à nouveau'} onPress={() => {
                        setScanned(false);
                        setScannedData(null);
                    }} />
                </View>
            )}
        </View>
    );
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        justifyContent: 'center',
        alignItems: 'center',
        backgroundColor: '#000',
    },
    camera: {
        ...StyleSheet.absoluteFillObject,
    },
    scanResultContainer: {
        position: 'absolute',
        bottom: 50,
        left: 20,
        right: 20,
        padding: 20,
        backgroundColor: 'white',
        borderRadius: 10,
        alignItems: 'center',
    },
    scanResultText: {
        fontSize: 18,
        marginBottom: 10,
    }
});

