from pydantic import BaseModel
from typing import List, Optional
from ..items.schemas import ItemSchema 

class CartItemBase(BaseModel):
    item_id: int
    quantity: int = 1

    class Config:
        orm_mode = True

class CartItemCreate(CartItemBase):
    """ Schéma pour ajouter un item au panier """
    pass

class CartItem(CartItemBase):
    """ Schéma pour afficher un item dans le panier """
    id: int
    item: ItemSchema

class CartSchema(BaseModel):
    """ Schéma principal du panier """
    id: int
    customer_id: str
    items: List[CartItem] = []

    class Config:
        orm_mode = True