from typing import Optional
from pydantic import BaseModel
from decimal import Decimal

class ItemBase(BaseModel):
    barcode_id: str
    product_name: str
    price: Optional[float] = None
    image_url: Optional[str] = None
    small_image_url: Optional[str] = None
    brands: Optional[str] = None
    nutrition_grade: Optional[str] = None
    product_quantity: Optional[int] = None
    product_quantity_unit: Optional[str] = None
    ingredients: Optional[str] = None
    allergens: Optional[str] = None
    rayon: Optional[str] = None
    attribut: Optional[str] = None
    conservation: Optional[str] = None

    class Config:
        orm_mode = True


class ItemSchema(ItemBase):
    item_id: int

    class Config:
        orm_mode = True

class AddItemSchema(ItemBase):
    pass


class RemoveItemSchema(BaseModel):
    id: int

    class Config:
        orm_mode = True


class PendingItem(BaseModel):
    id: int 
    amount: int

    class Config:
        orm_mode = True

class ItemPriceUpdate(BaseModel):
    price: float

class ItemDetailsUpdate(BaseModel):
    price: Decimal
    rayon: str
    attribut: str
    conservation: str

class PurchasedItem(BaseModel):
    item: Optional[ItemSchema]
    amount: int

    class Config:
        orm_mode = True