from sqlalchemy import Column, Integer, String, ForeignKey, Numeric
from sqlalchemy.orm import relationship

from ..database import Base

class Item(Base):
    __tablename__ = "items"

    item_id = Column(Integer, primary_key=True, index=True)
    barcode_id = Column(String, unique=True)
    image_url = Column(String, nullable=True)
    small_image_url = Column(String, nullable=True)
    product_name = Column(String, index=True)
    brands = Column(String, nullable=True)
    nutrition_grade = Column(String, nullable=True)
    product_quantity = Column(Integer, nullable=True)
    product_quantity_unit = Column(String, nullable=True)
    ingredients = Column(String, nullable=True)
    allergens = Column(String, nullable=True)
    price = Column(Numeric(10,2), nullable=False)
    rayon = Column(String, nullable=True)
    attribut = Column(String, nullable=True)
    conservation = Column(String, nullable=True)

    purchased_items = relationship("PurchasedItem")

class PurchasedItem(Base):
    __tablename__ = "purchased_items"

    id = Column(Integer, primary_key=True, index=True)

    amount = Column(Integer, nullable=False)

    payment_id = Column(Integer, ForeignKey("payments.id"))
    payment = relationship("Payment", back_populates="purchased_items")

    customer_id = Column(String, ForeignKey("customers.id"))
    customer = relationship("Customer", back_populates="purchased_items")

    item_id = Column(Integer, ForeignKey("items.item_id"))
    
    item = relationship("Item", back_populates="purchased_items")