import { Item } from '../types/Item';
import { CartItem } from '../types/CartItem';

export class CartService {
    private static cartItems: Map<String, CartItem> = new Map();

    public static addItemToCart(item: Item): CartItem {
        const barcodeId = item.getBarcodeId();
        let cartItem = CartService.cartItems.get(barcodeId);

        if (cartItem) {
            cartItem.incrementQuantity(1);
        } else {
            cartItem = new CartItem(item, 1);
            CartService.cartItems.set(barcodeId, cartItem);
        }

        console.log(`Article ${item.getProductName()} ajouté/mis à jour. Nouvelle quantité: ${cartItem.getQuantity()}`);
        return cartItem;
    }

    public static getDistinctItemCount(): number {
        return this.cartItems.size
    }

    public static incrementItemQuantity(barcodeId: String): CartItem | undefined {
        const cartItem = CartService.cartItems.get(barcodeId);
        if (cartItem) {
            cartItem.incrementQuantity(1);
            return cartItem;
        }
        return undefined;
    }

    public static decrementItemQuantity(barcodeId: String): CartItem | undefined {
        const cartItem = CartService.cartItems.get(barcodeId);
        if (cartItem) {
            cartItem.decrementQuantity(1);
            if (cartItem.getQuantity() <= 0) {
                CartService.cartItems.delete(barcodeId);
                return undefined;
            }
            return cartItem;
        }
        return undefined;
    }

    public static removeItemFromCart(barcodeId: String): boolean {
        const wasDeleted = CartService.cartItems.delete(barcodeId);
        if (wasDeleted) {
        }
        return wasDeleted;
    }

    public static clearCart(): void {
        CartService.cartItems.clear();
    }

    public static updateCartItem(updatedItem: Item) {
        const barcodeId = updatedItem.getBarcodeId();
        const cartItem = CartService.cartItems.get(barcodeId);

        if (cartItem) {
            cartItem.updateItem(updatedItem);
            return cartItem;
        }

        return undefined;
    }

    public static getCartItems(): CartItem[] {
        return Array.from(CartService.cartItems.values());
    }

    public static getTotalPrice(): Number {
        let total: number = 0;
        CartService.cartItems.forEach(cartItem => {
            total += cartItem.getTotalPrice() as number;
        });
        return total;
    }
}