import React, { useState } from 'react';
import { View, Text, TouchableOpacity, StyleSheet } from 'react-native';
import { FontAwesome } from '@expo/vector-icons';
import CartScreen from '../pages/CartScreen';
import RecapScreen from '../pages/RecapScreen'; // Assurez-vous que ce fichier existe

export default function CartNavigator() {
    const [currentScreen, setCurrentScreen] = useState<'cart' | 'recap'>('cart');

    const handleBack = () => {
        setCurrentScreen('cart');
    };

    if (currentScreen === 'recap') {
        return (
            <View style={{ flex: 1, backgroundColor: '#fff' }}>
                <View style={styles.headerContainer}>
                    <TouchableOpacity onPress={handleBack} style={styles.backButton}>
                        <FontAwesome name="arrow-left" size={20} color="#007AFF" />
                        <Text style={styles.backText}>Retour</Text>
                    </TouchableOpacity>
                    <Text style={styles.headerTitle}>Récapitulatif</Text>
                    <View style={{ width: 60 }} />
                </View>

                <RecapScreen />
            </View>
        );
    }

    return (
        <CartScreen
            onValidateCart={() => setCurrentScreen('recap')}
        />
    );
}

const styles = StyleSheet.create({
    headerContainer: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
        height: 60,
        paddingTop: 10,
        paddingHorizontal: 15,
        backgroundColor: '#fff',
        borderBottomWidth: 1,
        borderBottomColor: '#E5E5EA',
    },
    backButton: {
        flexDirection: 'row',
        alignItems: 'center',
        width: 70,
        height: '100%',
    },
    backText: {
        marginLeft: 5,
        fontSize: 17,
        color: '#007AFF',
    },
    headerTitle: {
        fontSize: 17,
        fontWeight: '600',
    }
});