import React from 'react';
import { createStackNavigator } from '@react-navigation/stack';
import HistoryScreen from '../pages/HistoryScreen';
import OrderDetailScreen from '../pages/OrderDetailScreen';

const Stack = createStackNavigator();

export default function HistoryNavigator() {
    return (
        <Stack.Navigator initialRouteName="HistoryList">
            <Stack.Screen
                name="HistoryList"
                component={HistoryScreen}
                options={{ headerShown: false }}
            />
            <Stack.Screen
                name="OrderDetailScreen"
                component={OrderDetailScreen}
                options={{
                    title: 'Détails de la commande',
                    headerBackTitle: 'Retour',
                    headerShown: false
                }}
            />
        </Stack.Navigator>
    );
}