import { StripeProvider } from '@stripe/stripe-react-native';
import ScannerScreen from './pages/ScannerScreen';
import CartScreen from './pages/CartScreen';
// import HistoryScreen from './pages/HistoryScreen'; 
import HistoryNavigator from './components/HistoryNavigator';
import SelectionScreen from './pages/SelectionScreen';
import SettingsScreen from './pages/SettingsScreen';
import { SafeAreaProvider } from 'react-native-safe-area-context';
import React from 'react';
import { useState } from 'react';
import { BottomNavigation, useTheme } from 'react-native-paper'; // Ajout de useTheme
import MaterialCommunityIcons from '@expo/vector-icons/MaterialCommunityIcons';
import { NavigationContainer, DefaultTheme, DarkTheme } from '@react-navigation/native';
import CartNavigator from './components/CartNavigator';
import { ThemeProvider, useAppTheme } from './context/ThemeContext'; // Import du contexte

function MainContent() {
  const stripePK = "pk_test_51SKwERQq66qTCnSLfpU75kBYasSolAbCKhA64jLG3r3q3XX4cCuJtv5M69juxlLE4Ptz0yp1fo8tSbxGFVMPecBv00AubYeo2l"
  const [index, setIndex] = useState(0);
  const { isDark } = useAppTheme();
  const theme = useTheme();

  const routes = [
    { key: 'produits', title: 'Produits', icon: 'cube' },
    { key: 'history', title: 'Historique', icon: 'history' },
    { key: 'scanner', title: 'Scanner', icon: 'barcode-scan' },
    { key: 'cart', title: 'Panier', icon: 'cart' },
    { key: 'settings', title: 'Paramètres', icon: 'cog' },
  ]

  const renderScene = ({ route }: { route: typeof routes[0] }) => {
    switch (route.key) {
      case 'cart': return <CartNavigator />;
      case 'history': return <HistoryNavigator />;
      case 'scanner': return <ScannerScreen />;
      case 'produits': return <SelectionScreen />;
      case 'settings': return <SettingsScreen />;
      default: return null;
    }
  }

  const navigationTheme = isDark ? DarkTheme : DefaultTheme;

  return (
    <SafeAreaProvider>
      <StripeProvider publishableKey={stripePK} merchantIdentifier="lola">
        <NavigationContainer theme={navigationTheme}>
          {renderScene({ route: routes[index] }) ?? <></>}

          <BottomNavigation.Bar
            navigationState={{ index, routes }}
            onTabPress={({ route }) => {
              const newIndex = routes.findIndex((r) => r.key === route.key);
              if (newIndex !== -1) setIndex(newIndex);
            }}
            style={{ backgroundColor: theme.colors.elevation.level2 }}
            activeColor={theme.colors.primary}
            inactiveColor={theme.colors.onSurfaceVariant}
            renderIcon={({ route, color }) => (
              <MaterialCommunityIcons name={route.icon as any} size={24} color={color} />
            )}
            getLabelText={({ route }) => route.title}
          />
        </NavigationContainer>
      </StripeProvider>
    </SafeAreaProvider>
  );
}

export default function App() {
  return (
    <ThemeProvider>
      <MainContent />
    </ThemeProvider>
  );
}