from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.orm import relationship
from ..database import Base

class Cart(Base):
    """
    Table principale du panier, liée à un client.
    Relation unique : un seul panier par client.
    """
    __tablename__ = "carts"

    id = Column(Integer, primary_key=True, index=True)
    
    customer_id = Column(String, ForeignKey("customers.id"), unique=True, index=True)
    
    customer = relationship("Customer")
    items = relationship("CartItem", back_populates="cart", cascade="all, delete-orphan")

class CartItem(Base):
    """
    Table des articles contenus dans un panier, avec leur quantité.
    """
    __tablename__ = "cart_items"
    
    id = Column(Integer, primary_key=True, index=True)
    cart_id = Column(Integer, ForeignKey("carts.id"))
    
    item_id = Column(Integer, ForeignKey("items.item_id")) 
    
    quantity = Column(Integer, default=1)
    
    cart = relationship("Cart", back_populates="items")
    item = relationship("Item")