export class Item {
    private barcode_id!: string;
    private product_name!: string;
    private image_url!: string;
    private small_image_url!: string;
    private brands!: string;
    private nutriscore_grade!: string;
    private product_quantity!: number;
    private product_quantity_unit!: string;
    private ingredients_text!: string;
    private allergens_imported!: string;
    private price!: number;
    private rayon!: string;
    private attribut!: string;
    private conservation!: string;

    constructor(barcode_id: string, product_name: string, image_url: string, small_image_url: string, brands: string, nutriscore_grade: string, product_quantity: number, product_quantity_unit: string, ingredients_text: string, allergens_imported: string, price: number = 0, rayon: string = 'Autre', attribut: string = 'Aucun', conservation: string = 'Sec') {
        this.barcode_id = barcode_id;
        this.product_name = product_name;
        this.image_url = image_url;
        this.small_image_url = small_image_url;
        this.brands = brands;
        this.nutriscore_grade = nutriscore_grade;
        this.product_quantity = product_quantity;
        this.product_quantity_unit = product_quantity_unit;
        this.ingredients_text = ingredients_text;
        this.allergens_imported = allergens_imported;
        this.price = price
        this.rayon = rayon;
        this.attribut = attribut;
        this.conservation = conservation;
    }

    public getBarcodeId(): string {
        return this.barcode_id;
    }

    public getProductName(): string {
        return this.product_name;
    }

    public getImageUrl(): string {
        return this.image_url;
    }

    public getSmallImageUrl(): string {
        return this.small_image_url
    }

    public getBrands(): string {
        return this.brands
    }

    public getNutriscoreGrade(): string {
        return this.nutriscore_grade
    }

    public getProductQuantity(): number {
        return this.product_quantity
    }

    public getProductQuantityUnit(): string {
        return this.product_quantity_unit
    }

    public getIngredeintsText(): string {
        return this.ingredients_text;
    }

    public getAllergensImported(): string {
        return this.allergens_imported;
    }

    public getPrice(): number {
        return this.price;
    }

    public getRayon(): string {
        return this.rayon;
    }

    public getAttribut(): string {
        return this.attribut;
    }

    public getConservation(): string {
        return this.conservation;
    }
}