import { Item } from './Item';

/*
Une classe représentant un article dans le panier d'achat.
Fonctionnalités:
- Stocke l'article et sa quantité.
- Permet d'incrémenter, décrémenter et mettre à jour la quantité.
- Calcule le prix total de l'article en fonction de la quantité.
*/

export class CartItem {
    private item: Item;
    private quantity: number;

    constructor(item: Item, initialQuantity: number = 1) {
        this.item = item;
        this.quantity = initialQuantity;
    }

    public getItem(): Item {
        return this.item;
    }

    public getQuantity(): number {
        return this.quantity;
    }

    public setQuantity(newQuantity: number): void {
        this.quantity = newQuantity;
    }

    public incrementQuantity(amount: number = 1): void {
        this.quantity += amount;
    }

    public decrementQuantity(amount: number = 1): void {
        this.quantity = Math.max(0, this.quantity - amount);
    }

    public getTotalPrice(): number {
        return (this.item.getPrice() as number) * this.quantity;
    }

    public updateItem(newItem: Item): void {
        this.item = newItem;
    }
}