import { CartItem } from './CartItem';

/*
Une classe représentant un panier d'achat.
Fonctionnalités:
- Stocke une liste d'articles dans le panier.
- Permet d'ajouter, de supprimer et de récupérer des articles.
- Permet de vider le panier.
*/

export class Cart {
    private items: CartItem[];

    constructor() {
        this.items = [];
    }

    public getItems(): CartItem[] {
        return this.items;
    }

    public addItem(newItem: CartItem): void {
        this.items.push(newItem);
    }

    public removeItem(barcodeId: String): void {
        this.items = this.items.filter(ci => ci.getItem().getBarcodeId() !== barcodeId);
    }

    public clear(): void {
        this.items = [];
    }
}