import React from 'react';
import { createStackNavigator } from '@react-navigation/stack';
import RayonListScreen from '../pages/selection/RayonListScreen';
import ItemsByRayonScreen from '../pages/selection/ItemsByRayonScreen';
import ItemDetailScreen from '../pages/selection/ItemDetailScreen';
import { SelectionStackParamList } from '../types/Navigation';

const Stack = createStackNavigator<SelectionStackParamList>();

/*
Un navigateur de pile (Stack Navigator) pour gérer la navigation entre les écrans liés à la sélection des articles.
Écrans inclus:
- RayonList: L'écran affichant la liste des rayons.
- ItemsByRayon: L'écran affichant les articles d'un rayon spécifique.
- ItemDetail: L'écran affichant les détails d'un article spécifique.
*/

export default function SelectionNavigator() {
    return (
        <Stack.Navigator initialRouteName="RayonList">
            <Stack.Screen
                name="RayonList"
                component={RayonListScreen}
                options={{ title: 'Rayons', headerShown: false }}
            />
            <Stack.Screen
                name="ItemsByRayon"
                component={ItemsByRayonScreen}
                options={({ route }) => ({ title: route.params.rayon, headerShown: false })}
            />
            <Stack.Screen
                name="ItemDetail"
                component={ItemDetailScreen}
                options={{ title: 'Détails Produit', headerShown: false }}
            />
        </Stack.Navigator>
    );
}