import React from 'react';
import { View, StyleSheet } from 'react-native';
import { Text, useTheme } from 'react-native-paper';
import { ScreenTitleProps } from '../interfaces/ScreenTitleProps';

/*
Un composant pour afficher le titre et le sous-titre d'un écran.
Props:
- title: Le titre principal de l'écran.
- subtitle: Un sous-titre optionnel à afficher sous le titre principal.
*/

export default function ScreenTitle({ title, subtitle }: ScreenTitleProps) {
    const theme = useTheme();

    return (
        <View style={[styles.headerContainer, {
            backgroundColor: theme.colors.background,
            borderColor: theme.colors.outlineVariant
        }]}>
            <Text style={[styles.headerTitle, { color: theme.colors.onBackground }]}>
                {title}
            </Text>
            {subtitle && (
                <Text style={[styles.subtitle, { color: theme.colors.onSurfaceVariant }]}>
                    {subtitle}
                </Text>
            )}
        </View>
    );
}

const styles = StyleSheet.create({
    headerContainer: {
        padding: 20,
        paddingTop: 60,
        borderBottomWidth: 1,
        width: '100%',
    },
    headerTitle: {
        fontSize: 28,
        fontWeight: '800',
        letterSpacing: 0.5,
    },
    subtitle: {
        fontSize: 16,
        marginTop: 4,
        fontWeight: '500',
    }
});