import React from 'react';
import { createStackNavigator } from '@react-navigation/stack';
import HistoryScreen from '../pages/HistoryScreen';
import OrderDetailScreen from '../pages/OrderDetailScreen';

const Stack = createStackNavigator();

/*
Un navigateur de pile (Stack Navigator) pour gérer la navigation entre les écrans liés à l'historique des commandes.
Écrans inclus:
- HistoryList: L'écran principal affichant la liste de l'historique des commandes.
- OrderDetailScreen: L'écran affichant les détails d'une commande spécifique.
*/

export default function HistoryNavigator() {
    return (
        <Stack.Navigator initialRouteName="HistoryList">
            <Stack.Screen
                name="HistoryList"
                component={HistoryScreen}
                options={{ headerShown: false }}
            />
            <Stack.Screen
                name="OrderDetailScreen"
                component={OrderDetailScreen}
                options={{
                    title: 'Détails de la commande',
                    headerBackTitle: 'Retour',
                    headerShown: false
                }}
            />
        </Stack.Navigator>
    );
}