import React from 'react';
import { createStackNavigator } from '@react-navigation/stack';
import CartScreen from '../pages/CartScreen';
import CartRecapScreen from '../pages/CartRecapScreen';
import HistoryScreen from '../pages/HistoryScreen';

const Stack = createStackNavigator();

/*
Un navigateur de pile (Stack Navigator) pour gérer la navigation entre les écrans liés au panier.
Écrans inclus:
- CartMain: L'écran principal du panier.
- CartRecapScreen: L'écran de récapitulatif du panier.
- HistoryScreen: L'écran d'historique des commandes.
*/

export default function CartNavigator() {
    return (
        <Stack.Navigator initialRouteName="CartMain">
            <Stack.Screen
                name="CartMain"
                component={CartScreen}
                options={{ headerShown: false }}
            />
            <Stack.Screen
                name="CartRecapScreen"
                component={CartRecapScreen}
                options={{
                    title: 'Récapitulatif',
                    headerBackTitle: 'Panier',
                    headerShown: false
                }}
            />
            <Stack.Screen
                name="HistoryScreen"
                component={HistoryScreen}
                options={{
                    title: 'Historique des commandes',
                    headerBackTitle: 'Récapitulatif',
                    headerShown: false
                }}
            />
        </Stack.Navigator>
    );
}