import { StyleSheet, Text, View } from "react-native";
import { Picker } from '@react-native-picker/picker';
import React from "react";

/*
Un composant réutilisable pour afficher un sélecteur (Picker) avec un label.
Props:
- label: Le texte du label à afficher au-dessus du sélecteur.
- selectedValue: La valeur actuellement sélectionnée dans le sélecteur.
- onValueChange: Une fonction de rappel appelée lorsque la valeur sélectionnée change.
- items: Un tableau de chaînes représentant les options disponibles dans le sélecteur.
*/

const AppPicker: React.FC<{
    label: string;
    selectedValue: string | undefined;
    onValueChange: (value: string | undefined) => void;
    items: string[];
}> = ({ label, selectedValue, onValueChange, items }) => (
    <>
        <Text style={styles.label}>{label}</Text>

        <View style={styles.pickerContainer}>

            <Picker
                selectedValue={selectedValue}
                onValueChange={onValueChange}
                style={styles.picker}
            >
                <Picker.Item label={`-- Sélectionner ${label} --`} value={undefined} />

                {items.map((item: string) => (
                    <Picker.Item label={item} value={item} key={item} />
                ))}
            </Picker>
        </View>
    </>
);

const styles = StyleSheet.create({
    label: {
        fontWeight: 'bold',
        marginTop: 10,
        color: '#333',
        width: '100%',
    },
    pickerContainer: {
        width: '100%',
        borderColor: '#ccc',
        borderWidth: 1,
        borderRadius: 8,
        marginTop: 5,
        marginBottom: 10,
        backgroundColor: '#f9f9f9',
        justifyContent: 'center',
    },
    picker: {
        width: '100%',
        height: 50,
    },
});

export default AppPicker;