# 🛒 Système de Caisse Mobile (Self-Checkout)

Ce projet est une solution Full-Stack conçue pour simuler une expérience d'auto-paiement (self-checkout). Il est constitué d'un **serveur backend API** (FastAPI) pour la logique métier, la gestion des stocks, du panier et des transactions Stripe, et d'une **application cliente mobile** (React Native/Expo) permettant aux utilisateurs de scanner et payer leurs articles.

---

## 1. Description et Fonctionnalités Clés

L'objectif principal est de fournir une plateforme complète pour l'achat en libre-service.

### 🌟 Fonctionnalités :
* **Scan d'Articles :** Ajout rapide et précis d'articles au panier via un scanner intégré (ou saisie manuelle).
* **Gestion de Panier :** Affichage en temps réel, modification des quantités, et suppression des articles du panier.
* **Navigation par Rayons :** Possibilité de sélectionner des produits manuellement en naviguant par catégories (`RayonListScreen`, `ItemsByRayonScreen`).
* **Paiement Intégré :** Finalisation de la commande et gestion sécurisée de la transaction via l'API Stripe.
* **Profil Client :** Création et gestion des identifiants client nécessaires au suivi des transactions.

---

## 2. Technologies Utilisées

| Composant | Technologie | Description |
| :--- | :--- | :--- |
| **Backend / API** | **FastAPI** (Python) | Serveur API RESTful pour le traitement des données et l'accès aux services. |
| **Conteneurisation** | **Docker** & **Docker Compose** | Gestion de l'environnement de développement et exécution du serveur. |
| **Paiement** | **Stripe** | Passerelle de paiement pour les transactions sécurisées. |
| **Frontend / Client** | **React Native / Expo** | Développement de l'application mobile multiplateforme (iOS/Android). |
| **Langages** | **Python**, **TypeScript** | Langages principaux de l'écosystème Backend et Frontend. |
| **Data** | **CSV** | Fichiers de données (ex: `server/assets/categories.csv`) utilisés pour initialiser certains éléments. |

---

## 3. Prérequis

Pour lancer et développer sur ce projet, vous devez installer :

* **Docker** et **Docker Compose** (pour le serveur).
* **Node.js** (v18+) et **npm** (pour le client).
* **Expo Go** installé sur votre appareil mobile ou un émulateur iOS/Android configuré.

---

## 4. Instructions d'Installation et de Démarrage

### 4.1. Serveur (Backend FastAPI)

#### A. Configuration des Variables d'Environnement

Créez un fichier nommé **`.env`** (à la racine du projet ou dans le dossier `server/`) et renseignez les variables de configuration :

| Variable | Description |
| :--- | :--- |
| `FASTAPI_PORT` | Le port sur lequel l'API sera écoutée (ex: `8000`). |
| `STRIPE_SK` | Votre **clé secrète** Stripe (`sk_live_...` ou `sk_test_...`). |
| `STRIPE_PK` | Votre **clé publique** Stripe (`pk_live_...` ou `pk_test_...`). |

**Exemple de fichier `.env` :**
```env
FASTAPI_PORT=8000
STRIPE_SK=sk_test_votre_cle_secrete_ici
STRIPE_PK=pk_test_votre_cle_publique_ici
```

#### B. Lancement du Serveur

Exécutez la commande docker compose pour construire l'image (si non existante) et démarrer le serveur :
Bash

docker compose up --build

Le serveur sera alors accessible à l'adresse http://<IP_DE_VOTRE_MACHINE>:<FASTAPI_PORT>.

### 4.2. Client (Application Mobile Expo)

#### A. Configuration des Accès (client/config.ts)

Accédez au fichier client/config.ts pour configurer la connexion à l'API et à Stripe.

    API_BASE_URL : Crucial. Doit contenir l'adresse IP de votre machine hôte (et non localhost) et le FASTAPI_PORT. Utilisez la commande ip a (sur Ubuntu) pour trouver l'adresse IP locale.

        Format attendu : http://[VOTRE_IP]:[FASTAPI_PORT]

    customer_ID : Initialisation requise. Lors de la première exécution, le client n'a pas d'ID. Vous devez appeler l'API du serveur avec la requête POST /customers/ pour obtenir un ID, puis mettre à jour cette variable.

    stripe_PK : Doit être la même clé publique Stripe fournie au serveur.

#### B. Installation et Lancement

Naviguez dans le répertoire client/ :
Bash

cd client/
npm i                # Installe les dépendances
npx expo install     # Installe les dépendances natives (le cas échéant)
npx expo start       # Lance le bundler Expo

Le serveur Expo démarrera. Scannez le QR code affiché avec l'application Expo Go pour lancer l'application sur votre appareil.

## 5. Structure du Projet

L'architecture est clairement séparée entre le backend et le frontend :
```py
.
├── client/                     # Code de l'Application Mobile (React Native / Expo)
│   ├── assets/                 
│   ├── components/             # Composants d'UI (AppPicker, CartNavigator, etc.)
|   ├── context/                # Récupère depuis la BDD côté client utilisant Expo.SQLite le thème de l'application.
|   ├── interfaces/             # Interfaces de donnée utilisées par les screen (CartInterface, ScannedItem, etc.)
│   ├── pages/                  # Écrans de l'application (ScannerScreen, CartScreen, etc.)
│   ├── services/               # Services de communication API (CartService, ItemService, PaiementService)
│   ├── types/                  # Définitions TypeScript (Cart, Item, Navigation)
│   └── config.ts               # Configuration de l'environnement client
│
└── server/                     # Code du Backend (FastAPI)
    ├── src/
    │   ├── core/               # Modules principaux (database, exceptions)
    │   ├── core/cart/          # Logique et routes du panier
    │   ├── core/customers/     # Logique et routes des clients
    │   ├── core/items/         # Logique et routes des articles
    │   └── core/payments/      # Logique et routes des paiements Stripe
    ├── assets/                 # Fichiers de données (ex: categories.csv)
    ├── Dockerfile              
    └── docker-compose.yml      
```

6. Commandes Utiles

| Contexte |	Commande |	Description |
|----------|-------------|--------------|
| Serveur (./server) |	docker compose up --build |	Démarre le backend FastAPI (inclut la construction de l'image). |
| Serveur (./server)|	docker compose down |	Arrête et supprime les conteneurs du serveur. |
| Client (./client) |	npm i |	Installe les dépendances JavaScript du client. |
| Client (./client) |	npx expo install |	Assure l'installation correcte des dépendances natives Expo. |
| Client (./client) |	npx expo start |	Lance le bundler Expo pour le développement. |