import { API_BASE_URL } from '../config';
import { Item } from '../types/Item';

export interface PurchasedItem {
    amount: number;
    item: {
        product_name: string;
        small_image_url: string;
        price: number;
    };
}

export interface Payment {
    id: string;
    checkout_date: string | null;
    total_price: number;
    is_checked: boolean;
    purchased_items: PurchasedItem[];
}

export class PaymentService {

    public static async getAllPayments(): Promise<Payment[]> {
        try {
            const response = await fetch(`${API_BASE_URL}/payments/`);

            if (!response.ok) {
                throw new Error(`Erreur HTTP: ${response.status}`);
            }

            const data = await response.json();
            return data as Payment[];
        } catch (error) {
            console.error("Erreur lors de la récupération des paiements:", error);
            throw error;
        }
    }

    public static async getPaymentsByCustomer(customerId: string): Promise<Payment[]> {
        try {
            const response = await fetch(`${API_BASE_URL}/payments/${customerId}`);
            if (!response.ok) throw new Error(`Erreur HTTP: ${response.status}`);
            return await response.json();
        } catch (error) {
            console.error("Erreur history client:", error);
            throw error;
        }
    }
}