import { CartItem } from './CartItem';

export class Cart {
    private items: CartItem[];

    constructor() {
        this.items = [];
    }

    public getItems(): CartItem[] {
        return this.items;
    }

    public addItem(newItem: CartItem): void {
        this.items.push(newItem);
    }

    public removeItem(barcodeId: String): void {
        this.items = this.items.filter(ci => ci.getItem().getBarcodeId() !== barcodeId);
    }

    public clear(): void {
        this.items = [];
    }
}