import React from 'react';
import { View, StyleSheet } from 'react-native';
import { Text, Switch, List, useTheme, Divider } from 'react-native-paper';
import { useAppTheme } from '../context/ThemeContext';
import ScreenTitle from '../components/ScreenTitle';

export default function SettingsScreen() {
    const { isDark, toggleTheme } = useAppTheme();
    const theme = useTheme();
    return (
        <View style={[styles.container, { backgroundColor: theme.colors.background }]}>
            <ScreenTitle title="Paramètres" />
            <List.Section>
                <List.Subheader style={{ color: theme.colors.primary }}>Apparence</List.Subheader>
                <List.Item
                    title="Mode Sombre"
                    description="Basculer entre le thème clair et sombre"
                    left={props => <List.Icon {...props} icon="theme-light-dark" />}
                    right={() => (
                        <Switch
                            value={isDark}
                            onValueChange={toggleTheme}
                            color={theme.colors.primary}
                        />
                    )}
                    titleStyle={{ color: theme.colors.onBackground }}
                    descriptionStyle={{ color: theme.colors.onSurfaceVariant }}
                />
            </List.Section>

            <Divider />

            <List.Section>
                <List.Subheader style={{ color: theme.colors.primary }}>Informations</List.Subheader>
                <List.Item
                    title="Version"
                    description="1.0.0"
                    left={props => <List.Icon {...props} icon="information-outline" />}
                    titleStyle={{ color: theme.colors.onBackground }}
                    descriptionStyle={{ color: theme.colors.onSurfaceVariant }}
                />
            </List.Section>
        </View>
    );
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
    },
    header: {
        padding: 20,
        paddingTop: 60,
        marginBottom: 10,
    },
});