import React from 'react';
import { createStackNavigator } from '@react-navigation/stack';
import CartScreen from '../pages/CartScreen';
import CartRecapScreen from '../pages/CartRecapScreen';
import HistoryScreen from '../pages/HistoryScreen';

const Stack = createStackNavigator();

export default function CartNavigator() {
    return (
        <Stack.Navigator initialRouteName="CartMain">
            <Stack.Screen
                name="CartMain"
                component={CartScreen}
                options={{ headerShown: false }}
            />
            <Stack.Screen
                name="CartRecapScreen"
                component={CartRecapScreen}
                options={{
                    title: 'Récapitulatif',
                    headerBackTitle: 'Panier',
                    headerShown: false
                }}
            />
            <Stack.Screen
                name="HistoryScreen"
                component={HistoryScreen}
                options={{
                    title: 'Historique des commandes',
                    headerBackTitle: 'Récapitulatif',
                    headerShown: false
                }}
            />
        </Stack.Navigator>
    );
}