import React from 'react';
import { createStackNavigator } from '@react-navigation/stack';
import HistoryScreen from '../pages/HistoryScreen';
import RecapScreen from '../pages/RecapScreen';

const Stack = createStackNavigator();

export default function HistoryNavigator() {
    return (
        <Stack.Navigator initialRouteName="HistoryList">
            <Stack.Screen
                name="HistoryList"
                component={HistoryScreen}
                options={{ headerShown: false }}
            />
            <Stack.Screen
                name="RecapScreen"
                component={RecapScreen}
                options={{
                    title: 'Détails de la commande',
                    headerBackTitle: 'Retour'
                }}
            />
        </Stack.Navigator>
    );
}