from sqlalchemy import Column, Integer, String, Decimal, ForeignKey
from sqlalchemy.orm import relationship

from ..database import Base

# Définir les champs de l'api open food facts pertinents aux items
class Item(Base):
    __tablename__ = "items"

    item_id = Column(Integer, primary_key=True, index=True)
    barcode_id = Column(String, unique=True)
    image_url = Column(String, nullable=True)
    small_image_url = Column(String, nullable=True)
    product_name = Column(String, index=True)
    brands = Column(String, nullable=True)
    nutrition_grade = Column(String, nullable=True)
    product_quantity = Column(Integer, nullable=True)
    product_quantity_unit = Column(String, nullable=True)
    ingredients = Column(String, nullable=True)
    allergens = Column(String, nullable=True)
    category = Column(String, nullable=True)
    price = Column(Decimal, nullable=False)

    purchased_items = relationship("PurchasedItem")

class PurchasedItem(Base):
    __tablename__ = "purchased_items"

    id = Column(Integer, primary_key=True, index=True)

    amount = Column(Integer, nullable=False)

    payment_id = Column(Integer, ForeignKey("payments.id"))
    payment = relationship("Payment", back_populates="purchased_items")

    customer_id = Column(String, ForeignKey("customers.id"))
    customer = relationship("Customer", back_populates="purchased_items")

    item_id = Column(Integer, ForeignKey("items.id"))
    item = relationship("Item", back_populates="purchased_items")
